import {RefObject, FunctionComponent, memo} from 'react';

import {deviceModDesktop} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import cx from './Anchor.scss';

interface IAnchorProps {
    anchorId?: string;
    anchorRef?: RefObject<HTMLDivElement>;
    anchorIds?: string[];
}

/**
 * Компонент добавляет якорь на страницу, уже с поправкой на fixed хедер
 */
const Anchor: FunctionComponent<IAnchorProps> = ({
    anchorId,
    anchorRef,
    anchorIds,
}) => {
    const deviceType = useDeviceType();

    return (
        <div className={cx('root')}>
            {(anchorId || anchorRef) && (
                <div
                    ref={anchorRef}
                    id={anchorId}
                    className={cx(
                        'anchor',
                        deviceModDesktop('anchor', deviceType),
                    )}
                />
            )}
            {anchorIds &&
                anchorIds.map(id => (
                    <div
                        key={id}
                        id={id}
                        className={cx(
                            'anchor',
                            deviceModDesktop('anchor', deviceType),
                        )}
                    />
                ))}
        </div>
    );
};

export default memo(Anchor);
