import {FC, ComponentType, ReactNode} from 'react';
import {Route, RouteProps} from 'react-router-dom';

interface IAppRouteProps extends RouteProps {
    meta: ComponentType;
}

const AppRoute: FC<IAppRouteProps> = ({
    meta: Meta,
    component: Component,
    render,
    ...rest
}) => {
    return (
        <Route
            {...rest}
            render={(props): ReactNode => (
                <>
                    <Meta />
                    {Component && <Component {...props} />}
                    {render && render(props)}
                </>
            )}
        />
    );
};

export default AppRoute;
