import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable, {
    ISizeDescription,
} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import Avatar, {IAvatarProps} from './Avatar';

export default {
    title: 'Example/Avatar',
    component: Avatar,
} as Meta;

const sizes: Pick<ISizeDescription, 'name' | 'size' | 'comment'>[] = [
    {
        name: 'xs',
        size: '20px',
    },
    {
        name: 's',
        size: '32px',
    },
    {
        name: 'm',
        size: '40px',
    },
    {
        name: 'l',
        size: '48px',
    },
    {
        name: 'xl',
        size: '52px',
    },
];

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={sizes.map(({name, size, comment}) => ({
            name: name,
            size: size,
            comment: comment,
            example: (
                <Avatar
                    size={name as IAvatarProps['size']}
                    src="https://avatars.mds.yandex.net/get-pdb/881477/2398e88e-e017-49bd-94cc-8fec35e73f64/s1200"
                />
            ),
        }))}
    />
);
