import {FC} from 'react';

import {IWithClassName} from 'src/types/withClassName';

/* Components */
import TravelImage from 'components/TravelImage/TravelImage';
import AvatarYandexPlusIconM from 'icons/illustrations/AvatarYandexPlusIcon/AvatarYandexPlusIconM';

/* Init Styles */
import cx from './Avatar.scss';

/* Components Types */
export interface IAvatarProps extends IWithClassName {
    src: string;
    size: 'xs' | 's' | 'm' | 'l' | 'xl';
    hasPlus?: boolean;
}

const Avatar: FC<IAvatarProps> = ({src, size, className, hasPlus}) => (
    <div className={cx('root')}>
        <TravelImage
            className={cx('avatar', `avatar_size_${size}`, className)}
            src={src}
            hasFitCover={true}
        />

        {hasPlus && (
            <AvatarYandexPlusIconM
                className={cx('plus', `plus_size_${size}`)}
            />
        )}
    </div>
);

export default Avatar;
