import React, {useMemo} from 'react';

import {EBaggageWithWeightIconSize} from 'components/BaggageIconWithWeight/BaggageIconWithWeight';
import HandLuggageNoSizeIcon24 from 'icons/24/HandLuggageNoSize';
import HandLuggageNoSizeIcon16 from 'icons/16/HandLuggageNoSize';
import HandLuggageIcon24 from 'icons/24/HandLuggage';
import HandLuggageIcon16 from 'icons/16/HandLuggage';

interface IBaggageIconProps {
    size: EBaggageWithWeightIconSize;
    empty?: boolean;
}

const CarryOnIcon: React.FC<IBaggageIconProps> = props => {
    const {size, empty = false} = props;

    const Icon = useMemo(() => {
        const isSmallSize = size === EBaggageWithWeightIconSize.S;

        if (empty) {
            return isSmallSize
                ? HandLuggageNoSizeIcon16
                : HandLuggageNoSizeIcon24;
        }

        return isSmallSize ? HandLuggageIcon16 : HandLuggageIcon24;
    }, [size, empty]);

    return <Icon />;
};

export default React.memo(CarryOnIcon);
