import React from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './BannerLine.scss';

interface IBannerLineProps extends IWithClassName {
    position: 'top' | 'bottom';
}

const BannerLine: React.FC<IBannerLineProps> = props => {
    const {position, children, className} = props;

    return (
        <div className={cx('root', className, `root_${position}`)}>
            {children}
        </div>
    );
};

export default BannerLine;
