import {Meta} from '@storybook/react/types-6-0';

import {SECOND} from 'utilities/dateUtils/constants';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useLeaving} from 'utilities/hooks/userBehavior/useLeaving';
import {useInactivity} from 'utilities/hooks/userBehavior/useInactivity';

export default {
    title: 'Example/Behavior',
} as Meta;

export const Inactivity: TStorybookFunctionComponent = () => {
    const isInactive = useInactivity(10 * SECOND);

    return isInactive ? (
        <div>Ура! У тебя получилось! *печенька*</div>
    ) : (
        <div>
            Если ты 10 секунд не будешь ничего делать, то получишь печеньку
        </div>
    );
};

export const Leaving: TStorybookFunctionComponent = () => {
    const isLeaving = useLeaving(0);

    return isLeaving ? (
        <div>Аха! Я вижу, что ты собираешься сделать</div>
    ) : (
        <div>Большой брат следит за тобой - не смей покидать страницу</div>
    );
};
