import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import BookLoader from './BookLoader';

export default {
    title: 'Example/BookLoader',
    component: BookLoader,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <BookLoader
        title="Заголовок"
        description="Описание"
        isModalView
        isLoading
    />
);

export const ModalView: TStorybookFunctionComponent = () => (
    <>
        Какой-то текст за лоадером
        <BookLoader
            title="Заголовок"
            description="Описание"
            isModalView
            isLoading
        />
    </>
);

ModalView.parameters = {
    info: {
        comment:
            'В данном варианте лоадер отображается поверх основного контента с полупрозрачным фоном',
    },
};
