import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Spinner, {TSpinnerSize} from 'components/Spinner/Spinner';

import cx from './BookLoader.scss';

interface IBookLoaderProps extends IWithClassName, IWithQaAttributes {
    title?: string;
    description?: string;
    isLoading?: boolean;
    isModalView?: boolean;
    spinnerSize?: TSpinnerSize;
}

const BookLoader: FunctionComponent<IBookLoaderProps> = ({
    className,
    title,
    description,
    spinnerSize = 'l',
    isModalView = false,
    isLoading = false,
    ...props
}) => {
    const {isMobile} = useDeviceType();

    if (!isLoading) {
        return null;
    }

    return (
        <section
            className={cx('bookLoader', className, {
                bookLoader_isModal: isModalView,
                bookLoader_mobile: isMobile,
            })}
            {...prepareQaAttributes(props)}
        >
            <Spinner size={spinnerSize} />
            {title && <h3 className={cx('title')}>{title}</h3>}
            {description && (
                <h5 className={cx('description')}>{description}</h5>
            )}
        </section>
    );
};

BookLoader.defaultProps = {
    ...prepareQaAttributes('loader'),
};

export default BookLoader;
