import {FC} from 'react';

import IPrice from 'types/common/price/IPrice';
import EOriginalPaymentErrorCode from 'types/common/EOriginalPaymentErrorCode';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import getPaymentErrorText from 'components/BookPaymentFailedModal/utilities/getPaymentErrorText';
import getPaymentErrorTitle from './utilities/getPaymentErrorTitle';
import getRetryPaymentButtonText from './utilities/getRetryPaymentButtonText';

import * as i18nBlock from 'i18n/hotels-BookPaymentFailed';

import PriceErrorModal from 'components/PriceErrorModal/PriceErrorModal';

interface IBookPaymentFailedModalProps extends IWithQaAttributes {
    errorCode?: EOriginalPaymentErrorCode;
    price?: IPrice;
    onRetryClick: () => void;
    onCancelClick: () => void;
    visible: boolean;
    retryUrl?: string;
}

const BookPaymentFailedModal: FC<IBookPaymentFailedModalProps> = ({
    errorCode = EOriginalPaymentErrorCode.OTHER,
    price,
    visible,
    onRetryClick,
    onCancelClick,
    retryUrl,
    ...props
}) => (
    <PriceErrorModal
        isVisible={visible}
        title={getPaymentErrorTitle(errorCode)}
        text={getPaymentErrorText(errorCode)}
        retryButtonText={getRetryPaymentButtonText(errorCode)}
        cancelButtonText={i18nBlock.buttonCancelText()}
        price={price}
        onCancelClick={onCancelClick}
        onRetryClick={onRetryClick}
        retryUrl={retryUrl}
        isDisabled={!visible}
        {...props}
    />
);

export default BookPaymentFailedModal;
