import React from 'react';

import IPrice from 'types/common/price/IPrice';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Card from 'components/Card/Card';
import Text from 'components/Text/Text';
import Price from 'components/Price/Price';

import cx from './BookPriceInfo.scss';

export interface IBookPriceInfoProps extends IWithClassName, IWithQaAttributes {
    text?: string;
    price: IPrice;
    lastPrice?: IPrice;
}

const BookPriceInfo: React.FC<IBookPriceInfoProps> = ({
    className,
    text,
    price,
    lastPrice,
    ...props
}) => {
    const {isMobile} = useDeviceType();

    return (
        <Card
            className={cx('root', className)}
            border="normal"
            y={isMobile ? 3 : 5}
        >
            {text && <Text size="m">{text}</Text>}
            <div>
                <Text size="xxl" weight="bold">
                    <Price
                        {...price}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'price',
                        })}
                    />
                </Text>
            </div>
            {lastPrice && (
                <div>
                    <Text
                        className={cx('lastPrice')}
                        size="xl"
                        weight="bold"
                        color="secondary"
                    >
                        <Price
                            {...lastPrice}
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'lastPrice',
                            })}
                        />
                    </Text>
                </div>
            )}
        </Card>
    );
};

export default BookPriceInfo;
