import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

const emailValidation: TField = {
    name: 'email',
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: 100,
                errorMessage: 'Не длиннее 100 символов',
            },
            {
                type: EValidationType.regex,
                params: '^[A-Za-z\\d.+\\-]+@[A-Za-z\\d.+\\-]+\\.(ru|com|org|vn)$', // и куча других захардкоженых доменов
                errorMessage:
                    '(сначала буковки и циферки)@(ещё буковки и циферки).(ру, ком... че там ещё есть)',
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
        ],
    },
};

export default emailValidation;
