import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

const phoneValidation: TField = {
    name: 'phone',
    validation: {
        blur: [
            {
                type: EValidationType.regex,
                params: '(\\+[\\d]{6,30})',
                errorMessage: 'Мобилу надо',
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: 'documentType',
                    },

                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: ['ru_national_passport'],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '(\\+7(\\d){4,10}))',
                        errorMessage:
                            'Если есть хоть один паспорт РФ, то телефон в РФ формате',
                    },
                ],
            },
        },
    ],
};

export default phoneValidation;
