import tlds from 'tlds';

export const isNotValidTLD = (value: string): boolean => {
    if (!value) {
        return false;
    }

    const atChunks = value.split('@');

    if (atChunks.length < 2) {
        return true;
    }

    const dotChunks = atChunks[1].split('.');

    if (dotChunks.length === 1) {
        return true;
    }

    const chunk = dotChunks.pop();

    if (!chunk) {
        return true;
    }

    return !tlds.includes(chunk.toLowerCase());
};

export const detectUnexpectedDot = (value: string): boolean => {
    if (!value) {
        return false;
    }

    return value
        .split('.')
        .some(
            chunk =>
                chunk.startsWith('@') ||
                chunk.endsWith('@') ||
                chunk.length === 0,
        );
};

export const detectUnexpectedLetters = (value: string): boolean => {
    if (!value) {
        return false;
    }

    return !value.split('').every(letter => /[a-zA-Z_.+\-@0-9]/.test(letter));
};

export const isDoubleAt = (value: string): boolean => {
    if (!value) {
        return false;
    }

    return value.split('@').length > 2;
};
