import * as i18nBlock from 'i18n/trains-order-fields-errors';

import {
    isDoubleAt,
    detectUnexpectedDot,
    detectUnexpectedLetters,
    isNotValidTLD,
} from './emailChecks';

export function getEmailValidationError(
    emailValue?: string,
): string | undefined {
    if (!emailValue) {
        return undefined;
    }

    const value = emailValue.trim();

    if (isDoubleAt(value)) {
        i18nBlock.isDashInvalidDashEmail();
    } else if (detectUnexpectedDot(value)) {
        return i18nBlock.emailDashUnexpectedDashDot();
    } else if (detectUnexpectedLetters(value)) {
        return i18nBlock.emailDashUnexpectedDashCyrillic();
    } else if (isNotValidTLD(value)) {
        return i18nBlock.emailDashInvalidDashTld();
    }

    return undefined;
}
