import React, {ReactNode, FunctionComponent} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {IDevice} from 'reducers/common/commonReducerTypes';

import Form from 'components/Form/Form';
import Button from 'components/Button/Button';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import BookingPassengerForm from './BookingPassengerForm';
import countries from './__mocks__/countries';
import passengers from './__mocks__/passengers';
import validationInfo from './__mocks__/validation/validationInfo';

export default {
    title: 'Example/BookingPassengerForm',
    component: BookingPassengerForm,
} as Meta;

interface IDeviceTypeChildren {
    children: (deviceType: IDevice) => React.ReactNode;
}

const Wrapper: FunctionComponent<IDeviceTypeChildren> = props => (
    <>
        <style>
            {`
                .passenger_mobile {
                    max-width: 400px;
                    padding: 16px;
                    border-bottom: 1px solid #999;
                }
            `}
        </style>
        <DeviceTypeContext.Consumer>
            {(deviceType): ReactNode => (
                <Form onSubmit={noop}>
                    {({handleSubmit}): ReactNode => (
                        <form
                            onSubmit={handleSubmit}
                            style={
                                deviceType.isMobile ? {marginBottom: 600} : {}
                            }
                        >
                            {props.children(deviceType)}
                            <div style={{marginTop: 15}}>
                                <Button type="submit">Submit</Button>
                            </div>
                        </form>
                    )}
                </Form>
            )}
        </DeviceTypeContext.Consumer>
    </>
);

export const OnlyName: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Только имя"
                    deviceType={deviceType}
                    passengers={passengers}
                    isOnlyName
                    hasPatronymic
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const OnlyNameWithoutPatronymic: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Только имя без отчества"
                    deviceType={deviceType}
                    passengers={passengers}
                    isOnlyName
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const WithoutPatronymicWithDate: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Взрослый - дата отправления 22.11.2020"
                    deviceType={deviceType}
                    countries={countries}
                    passengers={passengers}
                    hasDocumentDate
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const WithPatronymicWithoutDate: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Взрослый - дата отправления 22.11.2020"
                    deviceType={deviceType}
                    countries={countries}
                    passengers={passengers}
                    hasPatronymic
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const WithoutPatronymicWithoutDate: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Взрослый - дата отправления 22.11.2020"
                    deviceType={deviceType}
                    countries={countries}
                    passengers={passengers}
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const WithPatronymicWithDate: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger">
                <BookingPassengerForm
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Взрослый - дата отправления 22.11.2020"
                    deviceType={deviceType}
                    countries={countries}
                    passengers={passengers}
                    hasDocumentDate
                    hasPatronymic
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);

export const WithValidationInfo: TStorybookFunctionComponent = () => (
    <Wrapper>
        {(deviceType): ReactNode => (
            <Form.FieldGroup groupId="adultPassenger.0">
                <BookingPassengerForm
                    validationInfo={validationInfo}
                    className={deviceType.isMobile ? 'passenger_mobile' : ''}
                    title="Взрослый - дата отправления 22.11.2020"
                    deviceType={deviceType}
                    countries={countries}
                    passengers={passengers}
                />
            </Form.FieldGroup>
        )}
    </Wrapper>
);
