import {
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const birthdayValidation: TField = {
    name: EFieldName.birthdate,
    validation: {
        blur: [
            {
                type: EValidationType.minDate,
                params: '01.01.1900',
                errorMessage: 'Дата должна быть больше 01.01.1900',
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.minDate,
                params: '01.01.1900',
                errorMessage: 'Дата должна быть больше 01.01.1900',
            },
            {
                type: EValidationType.maxDateFromToday,
                params: {
                    offset: -10,
                    scale: 'year',
                },
                errorMessage:
                    'Для взрослого пассажира возраст должен быть более 10 лет',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxDateFromToday,
                        params: {
                            offset: -14,
                            scale: 'year',
                        },
                        errorMessage:
                            'Паспорт РФ может быть выдан гражданам старше 14 лет',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'passenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [MILITARY_CARD],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxDateFromField,
                        params: {
                            offset: -18,
                            scale: 'year',
                            field: {
                                fieldGroupId: 'adultPassenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Военный билет может быть выдан гражданам достигшим 18 лет в день отправления поезда',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [SAILOR_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxDateFromField,
                        params: {
                            offset: -14,
                            scale: 'year',
                            field: {
                                fieldGroupId: 'adultPassenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Паспорт моряка может быть выдан гражданам достигшим 14 лет в день отправления поезда',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.minDateFromField,
                        params: {
                            offset: -170,
                            scale: 'month',
                            field: {
                                fieldGroupId: 'adultPassenger',
                                fieldName: 'startDate',
                            },
                        },
                        errorMessage:
                            'Свидетельство о рождении может быть использовано при возрасте до 14 лет и 2 месяцев в день отправления поезда',
                    },
                ],
            },
        },
    ],
};
