import {DOCUMENT_OTHER} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const citizenshipValidation: TField = {
    name: EFieldName.citizenship,
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [DOCUMENT_OTHER],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage: 'Поле должно быть заполнено',
                    },
                ],
            },
        },
    ],
};
