import {ENG, RUS} from 'constants/form/masks';

import {CHAR_DASH, CHAR_EM_DASH} from 'utilities/strings/charCodes';

const DASHES = `${CHAR_DASH}${CHAR_EM_DASH}`;

const SEPARATORS = `\\s${DASHES}`;

export const EMPTY = '^$';
export {DASHES};

export const RUS_NAME = `^[${RUS}]+([${SEPARATORS}]+[${RUS}]+)*$`;
export const ENG_NAME = `^[${ENG}]+([${SEPARATORS}]+[${ENG}]+)*$`;

export const EMPTY_ENG_NAME = `(${ENG_NAME})|(${EMPTY})`;
export const EMPTY_RUS_NAME = `(${RUS_NAME})|(${EMPTY})`;

export const NAME_MASK = `${EMPTY_RUS_NAME}|${ENG_NAME}`;
