import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const documentDateValidation: TField = {
    name: EFieldName.documentValidDate,
    validation: {
        blur: [
            {
                type: EValidationType.minDateFromToday,
                params: {
                    offset: 0,
                    scale: 'day',
                },
                errorMessage: 'Дата должна быть больше 01.01.1900',
            },
        ],
    },
};
