import {
    RUSSIAN_PASSPORT,
    RUSSIAN_INTERNATIONAL_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
    DOCUMENT_OTHER,
} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const documentNumberValidation: TField = {
    name: EFieldName.documentNumber,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
        ],
    },
    dependentValidations: [
        /* Паспорт РФ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^\\d{2}\\d{2}\\d{6}$',
                        errorMessage:
                            'Паспорт должен быть в формате 1234 123456',
                    },
                    {
                        type: EValidationType.regex,
                        params: '^\\d{2}((9[789])|([01]\\d)|(2[0123]))',
                        errorMessage:
                            'Ошибка в серии паспорта (тест: ^\\d{2}((9[789])|([01]\\d)|(2[0123])))',
                    },
                ],
            },
        },
        /* Загран РФ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [RUSSIAN_INTERNATIONAL_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^\\d{9}$',
                        errorMessage: 'Error',
                    },
                ],
            },
        },
        /* Свидетельство о рождении */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [BIRTH_CERTIFICATE],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^((I{1,3}|IV|VI{0,3}|IX)|(X{1,2}(IX|IV|V?I{0,3}))|(XXXI{0,3}|XXXI?V))[А-ЯЁа-яё]{2}\\d{6}$',
                        errorMessage: 'Ошибка в номере',
                    },
                ],
            },
        },
        /* Военник */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [MILITARY_CARD],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^[А-ЯЁа-яё]{2}\\d{6,7}$',
                        errorMessage: 'Ошибка в номере',
                    },
                ],
            },
        },
        /* Паспорт моряка */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [SAILOR_PASSPORT],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: '^([A-Za-zА-ЯЁа-яё1-9]{2})(\\d{7})$',
                        errorMessage: 'Ошибка в номере',
                    },
                ],
            },
        },
        /* Другой документ */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [DOCUMENT_OTHER],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxLength,
                        params: 16,
                        errorMessage: 'Максимальная длинна 16 символов',
                    },
                ],
            },
        },
        /* Другой документ, если только латиница */
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [DOCUMENT_OTHER],
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'adultPassengers',
                        fieldName: EFieldName.documentNumber,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: '^[A-Za-z]+$',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.maxLength,
                        params: 5,
                        errorMessage:
                            'Минимальная длина 5 символов (только латиница)',
                    },
                ],
            },
        },
    ],
};
