import {
    RUSSIAN_PASSPORT,
    RUSSIAN_INTERNATIONAL_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
    DOCUMENT_OTHER,
} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const documentTypeValidation: TField = {
    name: EFieldName.documentType,
    validation: {
        blur: [
            {
                type: EValidationType.oneOf,
                params: [
                    RUSSIAN_PASSPORT,
                    RUSSIAN_INTERNATIONAL_PASSPORT,
                    BIRTH_CERTIFICATE,
                    SAILOR_PASSPORT,
                    MILITARY_CARD,
                    DOCUMENT_OTHER,
                ],
                errorMessage: 'Неверный тип документа',
            },
        ],
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.oneOf,
                params: [
                    RUSSIAN_PASSPORT,
                    RUSSIAN_INTERNATIONAL_PASSPORT,
                    BIRTH_CERTIFICATE,
                    SAILOR_PASSPORT,
                    MILITARY_CARD,
                    DOCUMENT_OTHER,
                ],
                errorMessage: 'Неверный тип документа',
            },
        ],
    },
};
