import {
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {ENG_NAME, NAME_MASK, RUS_NAME} from './common';
import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const firstNameValidation: TField = {
    name: EFieldName.firstName,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.maxLength,
                params: 20,
                errorMessage: 'Максимальная длина 20 символов',
            },
            {
                type: EValidationType.regex,
                params: NAME_MASK,
                errorMessage: 'Имя должно быть на кирилице или латинице',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [
                                RUSSIAN_PASSPORT,
                                BIRTH_CERTIFICATE,
                                SAILOR_PASSPORT,
                                MILITARY_CARD,
                            ],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: RUS_NAME,
                        errorMessage:
                            'Имя для выбранного документа должно быть на кириллице',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.lastName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.patronymicName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: RUS_NAME,
                        errorMessage:
                            'ФИО должны быть на одном языке (фамилия и отчество введены на кириллице)',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.lastName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.patronymicName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: ENG_NAME,
                        errorMessage:
                            'ФИО должны быть на одном языке (фамилия и отчество введены на латинице)',
                    },
                ],
            },
        },
    ],
};
