import {
    RUSSIAN_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
} from 'constants/document/documentTypes';
import {EFieldName} from '../../constants/fieldNames';

import {
    NAME_MASK,
    RUS_NAME,
    ENG_NAME,
    EMPTY_RUS_NAME,
    EMPTY_ENG_NAME,
} from './common';
import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const patronymicValidation: TField = {
    name: EFieldName.patronymicName,
    validation: {
        blur: [
            {
                type: EValidationType.maxLength,
                params: 20,
                errorMessage: 'Максимальная длина 20 символов',
            },
        ],
        submit: [
            {
                type: EValidationType.regex,
                params: NAME_MASK,
                errorMessage: 'Отчество должно быть на кирилице или латинице',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.isPatronymicDisabled,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [false],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.required,
                        params: true,
                        errorMessage: 'Поле должно быть заполнено',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.documentType,
                    },
                    value: [
                        {
                            type: EValidationType.oneOf,
                            params: [
                                RUSSIAN_PASSPORT,
                                BIRTH_CERTIFICATE,
                                SAILOR_PASSPORT,
                                MILITARY_CARD,
                            ],
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: EMPTY_RUS_NAME,
                        errorMessage:
                            'Отчество для выбранного документа должна быть на кириллице',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.firstName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.lastName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: RUS_NAME,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: EMPTY_RUS_NAME,
                        errorMessage:
                            'ФИО должны быть на одном языке (фамилия и имя введены на кириллице)',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.firstName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.lastName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: ENG_NAME,
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.regex,
                        params: EMPTY_ENG_NAME,
                        errorMessage:
                            'ФИО должны быть на одном языке (фамилия и имя введены на латинице)',
                    },
                ],
            },
        },
    ],
};
