import {EFieldName} from '../../constants/fieldNames';

import {EValidationType} from 'types/common/validation/validation';
import {TField} from 'types/common/validation/form';

export const sexValidation: TField = {
    name: EFieldName.sex,
    validation: {
        submit: [
            {
                type: EValidationType.required,
                params: true,
                errorMessage: 'Поле должно быть заполнено',
            },
            {
                type: EValidationType.oneOf,
                params: ['male', 'female'],
                errorMessage: 'Третьего не дано',
            },
        ],
    },
    dependentValidations: [
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.patronymicName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: '^.*((ич)|(лы))$',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.oneOf,
                        params: ['male'],
                        errorMessage:
                            'Для отчества на "ич", "лы", пол должен быть мужским',
                    },
                ],
            },
        },
        {
            conditions: [
                {
                    path: {
                        fieldGroupId: 'adultPassenger',
                        fieldName: EFieldName.patronymicName,
                    },
                    value: [
                        {
                            type: EValidationType.regex,
                            params: '^.*((на)|(зы))$',
                        },
                    ],
                },
            ],
            validation: {
                submit: [
                    {
                        type: EValidationType.oneOf,
                        params: ['female'],
                        errorMessage:
                            'Для отчества на "на", "зы", пол должен быть женским',
                    },
                ],
            },
        },
    ],
};
