import {IFormValidationInfo} from 'types/common/validation/form';

import {EFormKey} from 'constants/form/EFormKey';

import {lastNameValidation} from './lastName';
import {firstNameValidation} from './firstName';
import {patronymicValidation} from './patronymic';
import {sexValidation} from './sex';
import {documentTypeValidation} from './documentType';
import {documentNumberValidation} from './documentNumber';
import {citizenshipValidation} from './citizenship';
import {birthdayValidation} from './birthday';
import {documentDateValidation} from './documentDate';

const validationInfo: IFormValidationInfo = {
    id: EFormKey.TEST_FORM,
    fieldGroups: [
        {
            id: 'adultPassenger',
            fields: [
                lastNameValidation,
                firstNameValidation,
                patronymicValidation,
                sexValidation,
                birthdayValidation,
                documentTypeValidation,
                documentNumberValidation,
                citizenshipValidation,
                documentDateValidation,
            ],
        },
    ],
};

export default validationInfo;
