import {FunctionComponent, useMemo} from 'react';

import {ICountry} from 'types/common/ICountry';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';

import Select, {ISelectProps} from 'components/Select/Select';
import CountryItem from './components/CountryItem/CountryItem';

interface ICountrySelectProps
    extends Omit<ISelectProps<string, string>, 'options'> {
    countries: ICountry[];
}

const CountrySelect: FunctionComponent<ICountrySelectProps> = ({
    countries,
    ...inputProps
}) => {
    const countryOptions = useMemo(
        () =>
            countries.map(x => ({
                value: x.code2 || '',
                data: x.title,
            })),
        [countries],
    );

    return (
        <Select<string, string>
            {...inputProps}
            options={countryOptions}
            renderItem={CountryItem}
            renderValue={CountryItem}
            size="l"
            width="max"
            theme="outlined"
            placeholder={CHAR_EM_DASH}
            virtualizedMenuWidth={250}
            virtualized
        />
    );
};

export default CountrySelect;
