import {FunctionComponent} from 'react';

import FlagIcon from 'components/FlagIcon/FlagIcon';
import {ISelectOption} from 'components/Select/Select';

import cx from './CountryItem.scss';

interface ICountryItemProps extends ISelectOption<string, string> {}

const CountryItem: FunctionComponent<ICountryItemProps> = ({
    value,
    data,
    disabled,
}) => (
    <div className={cx('root', {root_disabled: disabled})}>
        {value && (
            <FlagIcon className={cx('icon')} country={value.toLowerCase()} />
        )}
        {data}
    </div>
);

export default CountryItem;
