import {FunctionComponent} from 'react';
import createAutoCorrectedDatePipe from 'text-mask-addons/dist/createAutoCorrectedDatePipe';

import {
    IMaskedInputProps,
    MaskedInput,
} from 'components/MaskedInput/MaskedInput';

const autoCorrectedDatePipe = createAutoCorrectedDatePipe('dd.mm.yyyy');
const dateMask = [/\d/, /\d/, '.', /\d/, /\d/, '.', /\d/, /\d/, /\d/, /\d/];

const DATE_PLACEHOLDER = '__.__.____';

interface IDateInputProps extends IMaskedInputProps {}

const DateInput: FunctionComponent<IDateInputProps> = ({name, ...props}) => {
    return (
        <MaskedInput
            {...props}
            id={name}
            placeholder={DATE_PLACEHOLDER}
            pipe={autoCorrectedDatePipe}
            mask={dateMask}
            inputMode="numeric"
            type="tel"
            keepCharPositions
            data-name={name}
        />
    );
};

export default DateInput;
