import {FunctionComponent} from 'react';

import Input from 'components/Input/Input';
import {
    IMaskedInputProps,
    MaskedInput,
} from 'components/MaskedInput/MaskedInput';

interface IDocumentNumberInput extends IMaskedInputProps {}

const DocumentNumberInput: FunctionComponent<IDocumentNumberInput> = ({
    name,
    ...props
}) => {
    const isMaskInput = 'mask' in props && props.mask;
    const InputComponent = isMaskInput ? MaskedInput : Input;
    const maskProps = isMaskInput ? {keepCharPositions: true} : {};

    return (
        <InputComponent
            {...props}
            value={props.value || ''}
            id={name}
            type="text"
            size="l"
            data-name={name}
            {...maskProps}
        />
    );
};

export default DocumentNumberInput;
