import _flatMap from 'lodash/flatMap';

import {isNotNullable} from 'types/utilities';
import {IContextDocument} from '../types/IContextDocument';

/**
 * Делает список документов плоским, выбирает из всех документов
 * тот у которого остался заполнен тип, либо первый по списку
 */
function flatMapDocuments(documents: IContextDocument[][]): IContextDocument[] {
    const documentList: (IContextDocument | undefined)[] = _flatMap(
        documents,
        docs => {
            const notEmptyDocument = docs.find(
                document => document.documentType,
            );

            return notEmptyDocument || docs[0];
        },
    );

    return documentList.filter(isNotNullable);
}

export default flatMapDocuments;
