import _omit from 'lodash/omit';

import {EDocumentType} from 'constants/document/documentTypes';
import {RU_CITIZENSHIP_CODE2} from 'constants/document/citizenship';
import {DOCUMENT_FIELDS} from '../../../constants/documentFields';

import {TDocumentType} from 'types/common/document/TDocumentType';
import {IContextDocument} from '../types/IContextDocument';

function omitDocumentsByAvailability(
    documents: IContextDocument[],
    avaliableDocuments?: TDocumentType[],
    excludeRuCitizenForOtherDocument?: boolean,
): IContextDocument[] {
    return documents.map(document => {
        const isRuExcludedDocument =
            excludeRuCitizenForOtherDocument &&
            document.citizenship === RU_CITIZENSHIP_CODE2 &&
            document.documentType === EDocumentType.OTHER;
        const isNotAvaliableDocuments =
            document.documentType &&
            avaliableDocuments &&
            !avaliableDocuments.includes(document.documentType);

        if (isNotAvaliableDocuments || isRuExcludedDocument) {
            return _omit(document, DOCUMENT_FIELDS);
        }

        return document;
    });
}

export default omitDocumentsByAvailability;
