import _omit from 'lodash/omit';

import {EFieldName} from '../../../constants/fieldNames';

import {IContextDocument} from '../types/IContextDocument';

type THandler = (document: IContextDocument) => IContextDocument;

interface IOmitParams {
    hasPatronymic?: boolean;
    isOnlyName?: boolean;
}

const PATRONYMIC_FIELDS = [
    EFieldName.patronymicName,
    EFieldName.isPatronymicDisabled,
] as const;
const NOT_NAME_FIELDS = [
    EFieldName.sex,
    EFieldName.birthdate,
    EFieldName.documentType,
    EFieldName.documentNumber,
    EFieldName.citizenship,
    EFieldName.documentValidDate,
] as const;

const omitPatronymics: THandler = document =>
    _omit(document, PATRONYMIC_FIELDS);
const omitNotName: THandler = document => _omit(document, NOT_NAME_FIELDS);

function omitDocumentsByParams(
    documents: IContextDocument[],
    omitParams: IOmitParams,
): IContextDocument[] {
    const handlers: THandler[] = [];

    if (!omitParams.hasPatronymic) {
        handlers.push(omitPatronymics);
    }

    if (omitParams.isOnlyName) {
        handlers.push(omitNotName);
    }

    return handlers.length
        ? documents.map(document =>
              handlers.reduce((result, handler) => handler(result), document),
          )
        : documents;
}

export default omitDocumentsByParams;
