import {memo, FC} from 'react';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';
import Box from 'components/Box/Box';

import cx from './FieldSkeleton.scss';

interface IFieldSkeletonProps {
    labelClassName: string;
}

const FieldSkeleton: FC<IFieldSkeletonProps> = props => {
    const {labelClassName} = props;

    return (
        <Box between={1}>
            <TextSkeleton className={cx(labelClassName)} size="s" />

            <ButtonSkeleton className={cx('control')} size="l" />
        </Box>
    );
};

export default memo(FieldSkeleton);
