import {memo, FC} from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import FieldSkeleton from 'components/BookingPassengerForm/components/skeletons/FieldsSkeleton/FieldSkeleton/FieldSkeleton';

import cx from './FieldsSkeleton.scss';

interface IFieldsSkeletonProps extends IWithClassName {}

const FieldsSkeleton: FC<IFieldsSkeletonProps> = props => {
    const {className} = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType), className)}>
            <FieldSkeleton labelClassName={cx('firstName')} />
            <FieldSkeleton labelClassName={cx('lastName')} />
            <FieldSkeleton labelClassName={cx('patronymic')} />
            <FieldSkeleton labelClassName={cx('gender')} />
        </div>
    );
};

export default memo(FieldsSkeleton);
