import {maskArray} from 'react-text-mask';

import {
    RUSSIAN_PASSPORT,
    RUSSIAN_INTERNATIONAL_PASSPORT,
    BIRTH_CERTIFICATE,
    SAILOR_PASSPORT,
    MILITARY_CARD,
    DOCUMENT_OTHER,
} from 'constants/document/documentTypes';

import {TDocumentType} from 'types/common/document/TDocumentType';

import * as i18nBlock from 'i18n/components-BookingPassengerForm-documents';

export interface IDocument {
    value: TDocumentType;
    data: string;
    hint?: string;
    mask?: maskArray;
    placeholder?: string;
    keyboardInputMode: 'numeric' | 'decimal' | 'text';
}

export const DOCUMENT_TYPES: IDocument[] = [
    {
        value: RUSSIAN_PASSPORT,
        data: i18nBlock.ruPassportDotTitle(),
        mask: [
            /\d/,
            /\d/,
            /\d/,
            /\d/,
            '\u2000',
            /\d/,
            /\d/,
            /\d/,
            /\d/,
            /\d/,
            /\d/,
        ],
        placeholder: '____\u2000______',
        hint: i18nBlock.ruPassportDotHint(),
        keyboardInputMode: 'decimal',
    },
    {
        value: RUSSIAN_INTERNATIONAL_PASSPORT,
        data: i18nBlock.ruForeignPassportDotTitle(),
        mask: [/\d/, /\d/, '\u2000', /\d/, /\d/, /\d/, /\d/, /\d/, /\d/, /\d/],
        placeholder: '__\u2000_______',
        hint: i18nBlock.ruForeignPassportDotHint(),
        keyboardInputMode: 'decimal',
    },
    {
        value: BIRTH_CERTIFICATE,
        data: i18nBlock.ruBirthCertificateDotTitle(),
        hint: i18nBlock.ruBirthCertificateDotHint(),
        keyboardInputMode: 'text',
    },
    {
        value: SAILOR_PASSPORT,
        data: i18nBlock.ruSeamanPassportDotTitle(),
        mask: [/\d/, /\d/, /\d/, /\d/, /\d/, /\d/, /\d/],
        hint: i18nBlock.ruSeamanPassportHint(),
        placeholder: '_______',
        keyboardInputMode: 'numeric',
    },
    {
        value: MILITARY_CARD,
        data: i18nBlock.ruMilitaryIdDotTitle(),
        hint: i18nBlock.ruMilitaryIdDotHint(),
        keyboardInputMode: 'text',
    },
    {
        value: DOCUMENT_OTHER,
        data: i18nBlock.otherDocumentDotTitle(),
        keyboardInputMode: 'text',
    },
];

export const DOCUMENTS_WITH_CITIZEN: TDocumentType[] = [DOCUMENT_OTHER];

export const DOCUMENTS_WITH_DATE: TDocumentType[] = [
    RUSSIAN_INTERNATIONAL_PASSPORT,
    DOCUMENT_OTHER,
];

export const DOCUMENT_NAMES: Record<TDocumentType, string> = {
    [RUSSIAN_PASSPORT]: i18nBlock.ruPassportDotTitle(),
    [RUSSIAN_INTERNATIONAL_PASSPORT]: i18nBlock.ruForeignPassportDotTitle(),
    [BIRTH_CERTIFICATE]: i18nBlock.ruBirthCertificateDotShortTitle(),
    [SAILOR_PASSPORT]: i18nBlock.ruSeamanPassportDotTitle(),
    [MILITARY_CARD]: i18nBlock.ruMilitaryIdDotTitle(),
    [DOCUMENT_OTHER]: i18nBlock.otherDocumentDotFullTitle(),
};
