import {EFieldName} from '../constants/fieldNames';

import {EGender} from 'types/common/document/EGender';
import {IFieldError} from 'types/common/validation/form';

import {EDocumentType} from 'server/api/TravelersApi/enums/EDocumentType';

export interface IFormDocumentMeta {
    isTranslatedLastName: boolean;
    isTranslatedFirstName: boolean;
    isTranslatedPatronymicName: boolean;
}

export interface IFormDocument<
    TDocumentType extends EDocumentType = EDocumentType,
> {
    [EFieldName.lastName]?: string;
    [EFieldName.firstName]?: string;
    [EFieldName.patronymicName]?: string;
    [EFieldName.sex]?: EGender;
    [EFieldName.birthdate]?: string;
    [EFieldName.documentType]?: TDocumentType;
    [EFieldName.documentNumber]?: string;
    /** Code2 страны */
    [EFieldName.citizenship]?: string;
    [EFieldName.documentValidDate]?: string;
    [EFieldName.isPatronymicDisabled]?: boolean;
}

export type TFormDocumentErrors = Partial<Record<EFieldName, IFieldError>>;

export interface IAutoCompleteDocument extends IFormDocument {
    meta: IFormDocumentMeta;
}

export interface ISuggestDocument extends IAutoCompleteDocument {
    title: string;
    comment?: string;
}

export interface IIntentDocument extends IAutoCompleteDocument {
    text: string;
    comment?: string;
}
