import {RUSSIAN_PASSPORT} from 'constants/document/documentTypes';

import {TDocumentType} from 'types/common/document/TDocumentType';

function isAvailableDocumentType(
    documentType: TDocumentType,
    availiableDocuments?: TDocumentType[],
): boolean {
    return availiableDocuments
        ? availiableDocuments.includes(documentType)
        : true;
}

/**
 * Проверяет начальное значение типа документа на доступность
 * и возвращает валидный начальный тип документа
 */
export function getInitialDocumentType(
    initialDocumentType?: TDocumentType,
    availiableDocuments?: TDocumentType[],
): TDocumentType {
    if (
        initialDocumentType &&
        isAvailableDocumentType(initialDocumentType, availiableDocuments)
    ) {
        return initialDocumentType;
    }

    if (availiableDocuments) {
        return availiableDocuments?.[0];
    }

    return RUSSIAN_PASSPORT;
}
