import {FunctionComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './BorderPositioned.scss';

export type TDirection =
    | 'top-left'
    | 'top-right'
    | 'top-right-plus'
    | 'bottom-right'
    | 'bottom-left';

export interface IBorderPositionedProps
    extends IWithClassName,
        IWithQaAttributes {
    badge: ReactNode;
    badgeClassName?: string;
    direction?: TDirection;
}

const BorderPositioned: FunctionComponent<IBorderPositionedProps> = ({
    className,
    badgeClassName,
    direction = 'top-right',
    badge,
    children,
    ...rest
}) => {
    return (
        <div className={cx('root', className)} {...prepareQaAttributes(rest)}>
            {children}
            {badge && (
                <div
                    className={cx(
                        'badge',
                        `badge_${direction}`,
                        badgeClassName,
                    )}
                >
                    {badge}
                </div>
            )}
        </div>
    );
};

export default BorderPositioned;
