import React from 'react';
import {Meta} from '@storybook/react/types-6-0';
import _times from 'lodash/times';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useToggle} from 'utilities/hooks/useToggle';

import Button from 'components/Button/Button';

import BottomSheet from './BottomSheet';

export default {
    title: 'Example/BottomSheet',
    component: BottomSheet,
} as Meta;

const text = `Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Eleifend quam adipiscing vitae proin sagittis nisl rhoncus mattis. Lobortis scelerisque fermentum dui faucibus in ornare quam viverra. Gravida arcu ac tortor dignissim convallis aenean. Quis ipsum suspendisse ultrices gravida dictum fusce ut placerat orci. Consectetur adipiscing elit duis tristique sollicitudin nibh. Placerat orci nulla pellentesque dignissim. Id volutpat lacus laoreet non curabitur. Faucibus pulvinar elementum integer enim neque. Amet purus gravida quis blandit turpis cursus. In massa tempor nec feugiat. Bibendum est ultricies integer quis auctor elit sed. Lacinia at quis risus sed vulputate odio ut. Tincidunt eget nullam non nisi. Blandit aliquam etiam erat velit scelerisque.`;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, toggle] = useToggle(false);

    return (
        <>
            <Button onClick={toggle}>Click Me</Button>
            <BottomSheet isOpened={isVisible} onClose={toggle}>
                <p>{text}</p>
            </BottomSheet>
        </>
    );
};

export const WithOverlay = (): React.ReactNode => {
    const [isVisible, toggle] = useToggle(false);

    return (
        <>
            <Button onClick={toggle}>Click Me</Button>
            <BottomSheet isOpened={isVisible} onClose={toggle}>
                <p>{text}</p>
            </BottomSheet>
        </>
    );
};

export const WithCloseButton = (): React.ReactNode => {
    const [isVisible, toggle] = useToggle(false);

    return (
        <>
            <Button onClick={toggle}>Click Me</Button>
            <BottomSheet isOpened={isVisible} onClose={toggle} hasCloseButton>
                <p>{text}</p>
            </BottomSheet>
        </>
    );
};

export const ScrollContent: TStorybookFunctionComponent = () => {
    const [isVisible, toggle] = useToggle(false);

    return (
        <>
            <Button onClick={toggle}>Click Me</Button>
            <BottomSheet isOpened={isVisible} onClose={toggle}>
                <div>
                    {_times(8, () => (
                        <p>{text}</p>
                    ))}
                </div>
            </BottomSheet>
        </>
    );
};

ScrollContent.parameters = {
    info: {
        comment:
            'Параметр `isScrollContent` задает возможный скролл внутри шторки за счет расчета высоты внутри',
    },
};
