import {useEffect, useContext, useRef} from 'react';

import BottomSheetManagerContext from './BottomSheetManagerContext';

interface IUseBottomSheetContextParams {
    layer: number;
    isOpened: boolean;
}

interface IUseBottomSheetContextResult {
    dragDisabled: boolean;
}

export default function useBottomSheetContext({
    layer,
    isOpened,
}: IUseBottomSheetContextParams): IUseBottomSheetContextResult {
    const context = useContext(BottomSheetManagerContext);

    const isOpenedRef = useRef<Boolean>();

    useEffect(() => {
        if (!isOpenedRef.current && isOpened) {
            context.onLayerOpened(layer);
        } else if (isOpenedRef.current && !isOpened) {
            context.onLayerClosed(layer);
        }

        isOpenedRef.current = isOpened;
    }, [context, layer, isOpened, isOpenedRef]);

    return {
        dragDisabled: !context.isLastLayer(layer),
    };
}
