import {FunctionComponent} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box, {IBoxProps, TBoxSizes} from './Box';

export default {
    title: 'Example/Box',
    component: Box,
} as Meta;

const ColorBox: FunctionComponent<IBoxProps> = props => (
    <Box
        {...props}
        style={{background: '#fc0', boxShadow: '0 0 3px rgba(0,0,0,0.2)'}}
    />
);

const Content: FunctionComponent<IBoxProps> = props => (
    <Box
        inset="2"
        style={{textAlign: 'center', background: '#fff', fontSize: '13px'}}
        {...props}
    />
);

/*
 * Истории
 */

export const Between: TStorybookFunctionComponent = () => (
    <ColorBox between="2">
        {Array.from(Array(4)).map((_, idx) => (
            <Content key={idx}>2</Content>
        ))}
    </ColorBox>
);
Between.parameters = {
    info: {
        comment: 'Параметр `between` для отступа между элементами',
    },
};

export const Inset: TStorybookFunctionComponent = () => (
    <Box between="1">
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox key={idx + 1} inset={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </Box>
);
Inset.parameters = {
    info: {
        comment: 'Параметр `inset` для задания внутренних отступов',
    },
};

export const Squish: TStorybookFunctionComponent = () => (
    <Box between="2">
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox squish key={idx + 1} inset={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </Box>
);
Squish.parameters = {
    info: {
        comment: 'Параметр `squish` для более мелких вертикальных отступов',
    },
};

export const SizeX: TStorybookFunctionComponent = () => (
    <Box between="2">
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox key={idx + 1} x={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </Box>
);
SizeX.parameters = {
    info: {
        comment: 'Параметр `x` для горизонтальных отступов',
    },
};

export const SizeY: TStorybookFunctionComponent = () => (
    <Box between="2">
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox key={idx + 1} y={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </Box>
);
SizeY.parameters = {
    info: {
        comment: 'Параметр `y` для вертикальных отступов',
    },
};

export const Inline: TStorybookFunctionComponent = () => (
    <Box between="2">
        <ColorBox between="1" inline>
            {Array.from(Array(4)).map((_, idx) => (
                <Content key={idx}>1</Content>
            ))}
        </ColorBox>
        <ColorBox between="2" inline>
            {Array.from(Array(4)).map((_, idx) => (
                <Content key={idx}>2</Content>
            ))}
        </ColorBox>
        <ColorBox between="3" inline>
            {Array.from(Array(4)).map((_, idx) => (
                <Content key={idx}>3</Content>
            ))}
        </ColorBox>
    </Box>
);
Inline.parameters = {
    info: {
        comment:
            'При добавлении параметра `inline` элементы выстроятся в линию',
    },
};

export const Above: TStorybookFunctionComponent = () => (
    <>
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox key={idx} above={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </>
);
Above.parameters = {
    info: {
        comment: 'Параметр `below` для внешнего отступа сверху',
    },
};

export const Below: TStorybookFunctionComponent = () => (
    <>
        {Array.from(Array(4)).map((_, idx) => (
            <ColorBox key={idx} below={(idx + 1) as TBoxSizes}>
                <Content>{idx + 1}</Content>
            </ColorBox>
        ))}
    </>
);
Below.parameters = {
    info: {
        comment: 'Параметр `below` для внешнего отступа снизу',
    },
};
