import React from 'react';
import {LocationDescriptor} from 'history';

import {BreadcrumbsListItem} from 'constants/schemaOrg/breadcrumbs';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Tabs from 'components/Tabs/Tabs';

export interface IBreadcrumbsItemProps
    extends IWithClassName,
        IWithQaAttributes {
    /** Помечает этот элемент активным, устанавливая красный border снизу */
    active?: boolean;

    disabled?: boolean;

    hasMicrodata?: boolean;

    innerRef?: React.Ref<HTMLButtonElement>;

    onClick?: React.MouseEventHandler;

    url?: string;
    to?: LocationDescriptor;
}

const BreadcrumbsItem: React.FC<IBreadcrumbsItemProps> = props => {
    const {
        className,
        active = false,
        disabled,
        hasMicrodata,
        children,
        innerRef,
        url,
        to,
        onClick,
    } = props;

    const microdataProps = hasMicrodata ? BreadcrumbsListItem : {};

    return (
        <Tabs.Tab
            className={className}
            {...microdataProps}
            active={active}
            disabled={disabled}
            bold={false}
            innerRef={innerRef}
            url={url}
            to={to}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            {children}
        </Tabs.Tab>
    );
};

export default BreadcrumbsItem;
