import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import ButtonLink from './ButtonLink';

export default {
    title: 'Example/ButtonLink',
    component: ButtonLink,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <ButtonLink url="/" target="_top">
        Ты думаешь, что я кнопка. А я ссылка
    </ButtonLink>
);

Simple.parameters = {
    info: {
        title: 'Компонент ссылки, которая выглядит как кнопка',
        comment: (
            <div>
                С параметром `url`, в качестве кнопки будет обычная ссылка `a`.
                <br />С параметром `to`, в качестве кнопки будет использован
                `Link` из `react-router-dom`
            </div>
        ),
    },
};
