export type TWeekDay = 0 | 1 | 2 | 3 | 4 | 5 | 6;
export type TMonthNumber = 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10 | 11;

export enum ECalendarType {
    StartDate = 'startDate',
    EndDate = 'endDate',
}

export enum ECalendarScrollSource {
    MonthsGrid = 'monthsGrid',
    MonthsGridMount = 'monthsGridMount',
    MonthsList = 'monthsList',
}

export interface ICalendarDay {
    day: number;
    weekDay?: TWeekDay;
    month: TMonthNumber;
    year: number;
}

export interface ICalendarMonth {
    month: TMonthNumber;
    monthLabel: string;
    year: number;
    monthDays: (false | ICalendarDay)[];
}

export type TWeekDayObject = {
    weekdayLabel: string;
    isWeekend: boolean;
};
