import _times from 'lodash/times';

import {
    SATURDAY_INDEX,
    SUNDAY_INDEX,
    DAYS_IN_WEEK,
} from '../constants/constants';

import {TWeekDayObject, TWeekDay} from 'components/Calendar/types';

import getWeekdayLabelByIndex from './getWeekdayLabelByIndex';

type TOptions = {
    weekStart?: number;
};

export default ({weekStart = 1}: TOptions): TWeekDayObject[] => {
    const weekdays = _times(DAYS_IN_WEEK, weekdayIndex => ({
        weekdayLabel: getWeekdayLabelByIndex({
            weekdayIndex: weekdayIndex as TWeekDay,
        }),
        isWeekend:
            weekdayIndex === SATURDAY_INDEX || weekdayIndex === SUNDAY_INDEX,
    }));

    if (weekStart === 1) {
        // as: Мы точно знаем из кода, что в массиве weekdays -- DAYS_IN_WEEK элементов
        const sundayItem = weekdays.shift() as TWeekDayObject;

        weekdays.push(sundayItem);
    }

    return weekdays;
};
