import {
    ECalendarType,
    ICalendarDay,
    ICalendarMonth,
} from 'components/Calendar/types';

import getCalendarDaySettings, {
    TCalendarDaySettings,
} from 'components/Calendar/utilities/getCalendarDaySettings';

type TCalendarProps = {
    months: ICalendarMonth[];
    nowDate: Date;
    minDate: Date;
    maxDate: Date;
    endDate: Date;
    startDate: Date;
    hoveredDate?: Date;
    calendarType?: ECalendarType;
    newExperimentalCalendar?: boolean;
    canSelectRange?: boolean;
};

export type TDayInfo = {monthIndex: number; day?: ICalendarDay};
type TPredicate = (day: TCalendarDaySettings) => boolean | undefined;

function findMonthDay(
    predicate: TPredicate,
    props: TCalendarProps,
): TDayInfo | undefined {
    const {months} = props;

    for (let i = 0; i < months.length; i++) {
        const dayToScroll = months[i].monthDays.find(day =>
            predicate(
                getCalendarDaySettings({
                    day,
                    ...props,
                }),
            ),
        );

        if (dayToScroll) {
            return {
                monthIndex: i,
                day: dayToScroll,
            };
        }
    }
}

export default findMonthDay;
