import getUTCDateByDate from './getUTCDateByDate';

const padHelper = (number: number): string | number => {
    if (number < 10) {
        return '0' + number;
    }

    return number;
};

export default (date: Date, delimiter = '-'): string => {
    const preparedDate = getUTCDateByDate(date);
    const year = preparedDate.getUTCFullYear();
    const month = padHelper(preparedDate.getUTCMonth() + 1);
    const day = padHelper(preparedDate.getUTCDate());

    return [year, month, day].join(delimiter);
};
