import {TMonthNumber} from 'calendar-base';
import moment from 'moment';

import capitalizeFirstLetter from 'utilities/strings/capitalizeFirstLetter';

type TOptions = {
    monthIndex: TMonthNumber;
};

const months = moment.months();

export default ({monthIndex}: TOptions): string => {
    return capitalizeFirstLetter(months[monthIndex]);
};
