import moment from 'moment';

import {HUMAN, HUMAN_SHORT} from 'utilities/dateUtils/formats';

type TOptions = {
    isShortFormatDate: boolean;
};

export default (date: Date, {isShortFormatDate}: TOptions): string => {
    const format = isShortFormatDate ? HUMAN_SHORT : HUMAN;

    return moment.utc(date).format(format);
};
